/*
 * Decompiled with CFR 0.152.
 */
package org.steveshipway.worldgen.cmd;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.storage.ISaveHandler;
import org.steveshipway.worldgen.WorldGen;

public class GenCommand
implements ICommand {
    private List aliases = new ArrayList();
    private static BlockPos from;
    private static BlockPos to;
    private static BlockPos centre;
    private static int radius;

    public void generateChunks(ICommandSender ics) {
        World world;
        int cnt = 0;
        if (ics instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)ics;
            world = player.field_70170_p;
        } else {
            world = ics.func_130014_f_();
        }
        if (from == null || to == null) {
            ics.func_145747_a((IChatComponent)new ChatComponentText("Please first set a region to generate using '/worldgen set'"));
            return;
        }
        int totchunks = radius > 0 ? (int)Math.ceil(Math.PI * Math.pow(radius / 16, 2.0) + 1.0) : (int)((Math.abs(Math.floor(from.func_177958_n() / 16) - Math.floor(to.func_177958_n() / 16)) + 1.0) * (Math.abs(Math.floor(from.func_177952_p() / 16) - Math.floor(to.func_177952_p() / 16)) + 1.0));
        BlockPos cfrom = new BlockPos(from.func_177958_n() / 16, 0, from.func_177952_p() / 16);
        BlockPos cto = new BlockPos(to.func_177958_n() / 16, 0, to.func_177952_p() / 16);
        int t = (int)Math.floor(totchunks / 500);
        ics.func_145747_a((IChatComponent)new ChatComponentText("Starting Generation of " + totchunks + " chunks"));
        ics.func_145747_a((IChatComponent)new ChatComponentText("Estimated time: " + t + " minutes"));
        ics.func_145747_a((IChatComponent)new ChatComponentText("Server thread will now appear to hang.  Watch log window for progress."));
        WorldGen.logger.info("Starting generation: estimate " + totchunks + " chunks, " + t + " minutes");
        ISaveHandler sh = world.func_72860_G();
        world.func_72959_q().func_76938_b();
        ChunkProviderServer cps = MinecraftServer.func_71276_C().field_71305_c[0].field_73059_b;
        Iterable i = BlockPos.func_177975_b((BlockPos)cfrom, (BlockPos)cto);
        for (BlockPos chk : i) {
            int d;
            if (radius > 0 && (d = (int)Math.floor(Math.sqrt(Math.pow(chk.func_177958_n() * 16 + 8 - centre.func_177958_n(), 2.0) + Math.pow(chk.func_177952_p() * 16 + 8 - centre.func_177952_p(), 2.0)))) > radius) continue;
            if (!cps.func_73149_a(chk.func_177958_n(), chk.func_177952_p())) {
                cps.func_73158_c(chk.func_177958_n(), chk.func_177952_p());
                if (!cps.func_73151_a(true, null)) {
                    WorldGen.logger.info("Pending unsaved chunks exist");
                }
                cps.func_73156_b();
                cps.func_73241_b(chk.func_177958_n(), chk.func_177952_p());
            }
            if ((++cnt & 0x7F) == 0) {
                WorldGen.logger.info("Completed " + cnt + " chunks (" + Math.floor((double)cnt * 1000.0 / (double)totchunks) / 10.0 + "%) (Loaded:" + cps.func_73152_e() + ")");
                ics.func_145747_a((IChatComponent)new ChatComponentText("Completed " + cnt + " chunks (" + Math.floor((double)cnt * 1000.0 / (double)totchunks) / 10.0 + "%)"));
                if (!world.func_72863_F().func_73151_a(true, null)) {
                    WorldGen.logger.warn("Unable to save all pending chunks");
                }
                sh.func_75759_a();
                cps.func_73156_b();
                world.func_72959_q().func_76938_b();
            }
            world.func_72835_b();
        }
        ics.func_145747_a((IChatComponent)new ChatComponentText("Completed " + cnt + " chunks"));
        ics.func_145747_a((IChatComponent)new ChatComponentText("Generation Complete"));
    }

    public GenCommand() {
        this.aliases.add("worldgen");
        this.aliases.add("wg");
        this.aliases.add("gen");
    }

    public String func_71517_b() {
        return "worldgen";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "worldgen <set [<x1> <z1>] <<x2> <z2>|<r>>|go>";
    }

    public List func_71514_a() {
        return this.aliases;
    }

    public void func_71515_b(ICommandSender icommandsender, String[] astring) {
        block14: {
            block16: {
                block15: {
                    int totchunks = 0;
                    if (icommandsender instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)icommandsender;
                        if (!player.field_71075_bZ.field_75098_d) {
                            player.func_145747_a((IChatComponent)new ChatComponentText("You must be in Creative mode"));
                            return;
                        }
                    }
                    if (astring.length < 1) {
                        icommandsender.func_145747_a((IChatComponent)new ChatComponentText("Please specify 'set' or 'go'"));
                        return;
                    }
                    WorldGen.logger.info("Processing command [" + astring[0] + "]");
                    if (astring[0].startsWith("set")) {
                        if (astring.length < 2) {
                            icommandsender.func_145747_a((IChatComponent)new ChatComponentText("Please specify 'set [<x> <z>] <x2> <z2>' or 'set [<x> <z>] <r>'"));
                            icommandsender.func_145747_a((IChatComponent)new ChatComponentText("Specify center and radius for a circle or two points for a square"));
                            if (icommandsender instanceof EntityPlayer) {
                                icommandsender.func_145747_a((IChatComponent)new ChatComponentText("Primary point defaults to current location."));
                            } else {
                                icommandsender.func_145747_a((IChatComponent)new ChatComponentText("Primary point defaults to spawn point"));
                            }
                            return;
                        }
                        from = astring.length < 4 ? (icommandsender instanceof EntityPlayer ? new BlockPos((int)((EntityPlayer)icommandsender).field_70165_t, 0, (int)((EntityPlayer)icommandsender).field_70161_v) : icommandsender.func_130014_f_().func_175694_M()) : new BlockPos((double)Integer.parseInt(astring[1]), 0.0, (double)Integer.parseInt(astring[2]));
                        if (astring.length == 4 || astring.length == 2) {
                            centre = new BlockPos((Vec3i)from);
                            radius = Integer.parseInt(astring[astring.length - 1]);
                            from = new BlockPos((double)(centre.func_177958_n() - radius), 0.0, (double)(centre.func_177952_p() - radius));
                            to = new BlockPos((double)(centre.func_177958_n() + radius), 0.0, (double)(centre.func_177952_p() + radius));
                        } else {
                            radius = 0;
                            to = new BlockPos((double)Integer.parseInt(astring[astring.length - 2]), 0.0, (double)Integer.parseInt(astring[astring.length - 1]));
                        }
                        totchunks = radius > 0 ? (int)Math.floor(Math.PI * Math.pow(Math.floor(radius / 16), 2.0) + 1.0) : (int)((Math.abs(Math.floor(from.func_177958_n() / 16) - Math.floor(to.func_177958_n() / 16)) + 1.0) * (Math.abs(Math.floor(from.func_177952_p() / 16) - Math.floor(to.func_177952_p() / 16)) + 1.0));
                        if (radius > 0) {
                            icommandsender.func_145747_a((IChatComponent)new ChatComponentText("Selected area is a circle radius " + radius + " blocks centered on " + centre.func_177958_n() + "," + centre.func_177952_p()));
                            icommandsender.func_145747_a((IChatComponent)new ChatComponentText("Within a rectangle from " + from.func_177958_n() + "," + from.func_177952_p() + " to " + to.func_177958_n() + "," + to.func_177952_p()));
                        } else {
                            icommandsender.func_145747_a((IChatComponent)new ChatComponentText("Selected area is a rectangle from " + from.func_177958_n() + "," + from.func_177952_p() + " to " + to.func_177958_n() + "," + to.func_177952_p()));
                        }
                        icommandsender.func_145747_a((IChatComponent)new ChatComponentText("Selected area contains approximately " + totchunks + " chunks"));
                        int t = (int)Math.floor(totchunks / 500);
                        icommandsender.func_145747_a((IChatComponent)new ChatComponentText("Estimated time: " + t + " minutes"));
                        icommandsender.func_145747_a((IChatComponent)new ChatComponentText("Use '/worldgen go' to start generation"));
                        return;
                    }
                    if (!astring[0].startsWith("go")) break block14;
                    if (from == null) break block15;
                    if (to != null) break block16;
                }
                icommandsender.func_145747_a((IChatComponent)new ChatComponentText("You have not yet set the boundaries of the generation area using '/worldgen set'."));
                return;
            }
            this.generateChunks(icommandsender);
            return;
        }
        icommandsender.func_145747_a((IChatComponent)new ChatComponentText("Invalid subcommand : " + astring[0]));
    }

    public boolean func_71519_b(ICommandSender icommandsender) {
        if (icommandsender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)icommandsender;
            if (player.field_71075_bZ.field_75098_d) {
                return true;
            }
            player.func_145747_a((IChatComponent)new ChatComponentText("You must be in Creative mode"));
            return false;
        }
        return true;
    }

    public List func_180525_a(ICommandSender icommandsender, String[] astring, BlockPos bp) {
        ArrayList<String> l = null;
        if (astring.length == 0) {
            l = new ArrayList<String>();
            l.add("go");
            l.add("set");
            return l;
        }
        return null;
    }

    public boolean func_82358_a(String[] astring, int i) {
        return false;
    }

    public int compareTo(Object o) {
        return 0;
    }

    static {
        radius = 0;
    }
}

