package org.steveshipway.worldgen;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import org.apache.logging.log4j.Logger;
import org.steveshipway.worldgen.lib.Constants;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;

// Minecraft 1.7
//import cpw.mods.fml.common.Mod;
//import cpw.mods.fml.common.Mod.EventHandler;
//import cpw.mods.fml.common.Mod.Instance;
//import cpw.mods.fml.common.Mod.Metadata;
//import cpw.mods.fml.common.ModMetadata;
//import cpw.mods.fml.common.SidedProxy;
//import cpw.mods.fml.common.event.FMLInitializationEvent;
//import cpw.mods.fml.common.event.FMLPostInitializationEvent;
//import cpw.mods.fml.common.event.FMLPreInitializationEvent;
//import cpw.mods.fml.common.event.FMLServerStartingEvent;
// Minecraft 1.8
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Mod.EventHandler;
import net.minecraftforge.fml.common.Mod.Instance;
import net.minecraftforge.fml.common.Mod.Metadata;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@Mod(modid = Constants.MODID, name = Constants.MODNAME, version = Constants.VERSION,
		useMetadata = true)
public class WorldGen
{    
   
	@Metadata(value = Constants.MODID)
	public static ModMetadata metadata;
	
	@SidedProxy(clientSide = "org.steveshipway.worldgen.ClientProxy", 
			serverSide = "org.steveshipway.worldgen.CommonProxy")
	public static CommonProxy proxy;

	public static Logger logger;
		
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
    	logger = event.getModLog();
    	logger.info("Starting " + Constants.MODNAME + "("+Constants.MODID+") : Ver " + Constants.VERSION);
    	
    	proxy.preInit(event);
    }
 
    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    	proxy.init(event);
    	// special client renderers
    	proxy.registerRenderers();
    }
 
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    	proxy.postInit(event);
    }
    
    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event)
    {
        logger.info("Loading server console commands.");
        proxy.serverLoad(event);
    }
    

}
