package org.steveshipway.worldgen.cmd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.steveshipway.worldgen.WorldGen;
import org.steveshipway.worldgen.lib.Constants;

import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ChunkLoader;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.storage.ISaveHandler;
// Minecraft 1.7
//import net.minecraft.util.ChunkCoordinates;
//import org.steveshipway.blueprints.util17.*;
// Minecraft 1.8
import net.minecraft.util.BlockPos;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeChunkManager.Ticket;
import net.minecraftforge.common.ForgeChunkManager.Type;

public class GenCommand implements ICommand {
	  private List aliases;
	  
	  private static BlockPos from, to;
	  private static BlockPos centre;
	  private static int radius = 0;

	  public void generateChunks(ICommandSender ics) {
		  EntityPlayer player;
		  World world;
		  int totchunks;
		  int cnt = 0;
		  int cx,cz;
		  BlockPos cfrom, cto;
		  BlockPos blk;
		  int t;
          
          if(ics instanceof EntityPlayer){
                  player = (EntityPlayer)ics;
    	    	  world = player.worldObj;
          } else {
                  world = ics.getEntityWorld();
          }
          if( from == null || to == null ) {
        	  ics.addChatMessage(new ChatComponentText("Please first set a region to generate using '/worldgen set'"));
        	  return;
          }
          if(radius>0) {
        	  totchunks = (int) Math.ceil(Math.PI * Math.pow(radius/16, 2.0)+1);
          } else {
        	  totchunks = (int) ((Math.abs(Math.floor(from.getX()/16)-Math.floor(to.getX()/16))+1) * (Math.abs(Math.floor(from.getZ()/16)-Math.floor(to.getZ()/16))+1)); 
          }
          // chunk coordinates.  held in blockpos so we can iterate
          cfrom = new BlockPos(from.getX()/16,0,from.getZ()/16);
          cto   = new BlockPos(to.getX()/16,0,to.getZ()/16);
          t = (int)Math.floor(totchunks / Constants.CHUNKRATE);
    	  ics.addChatMessage(new ChatComponentText("Starting Generation of "+totchunks+" chunks"));
    	  ics.addChatMessage(new ChatComponentText("Estimated time: "+t+" minutes"));
    	  ics.addChatMessage(new ChatComponentText("Server thread will now appear to hang.  Watch log window for progress."));
    	  
    	  //ics.addChatMessage(new ChatComponentText("From block: "+from.getX()+","+from.getZ()));
    	  //ics.addChatMessage(new ChatComponentText("To block  : "+to.getX()+","+to.getZ()));
    	  //ics.addChatMessage(new ChatComponentText("From chunk: "+cfrom.getX()+","+cfrom.getZ()));
    	  //ics.addChatMessage(new ChatComponentText("To chunk  : "+cto.getX()+","+cto.getZ()));

    	  WorldGen.logger.info("Starting generation: estimate "+totchunks+" chunks, "+t+" minutes");
    	  ISaveHandler sh = world.getSaveHandler();
    	  //IChunkLoader cl = sh.getChunkLoader(world.provider);
    	  //IChunkProvider cp = world.getChunkProvider();
		  ChunkProviderServer cps;
		  world.getWorldChunkManager().cleanupCache();
		  
		  cps = MinecraftServer.getServer().worldServers[0].theChunkProviderServer;
		  
    	  Iterable<BlockPos> i = BlockPos.getAllInBoxMutable(cfrom, cto);
    	  for( BlockPos chk : i ) {
	    	  //ics.addChatMessage(new ChatComponentText("Chunk "+chk.getX()+","+chk.getZ()));    			  
    		  if( radius > 0 ) {
    			  int d = (int) Math.floor(Math.sqrt(Math.pow((chk.getX()*16+8 - centre.getX()),2)+Math.pow((chk.getZ()*16+8 - centre.getZ()),2)));
    			 // do we skip this one as it is outside the circle?
    			  if( d > radius ) { 
    		    	  //ics.addChatMessage(new ChatComponentText("Skipping chunk because "+d+" > "+radius));    		
    				  continue; 
    			  }
    		  }
    		  
    		  if( ! cps.chunkExists(chk.getX(), chk.getZ() )) { 
    			  
    			  //blk = new BlockPos(chk.getX()*16+8,0,chk.getZ()*16+8); // centre of the chunk
    			  //world.getBlockState(blk); // implicitly generate chunk if necessary

    			  cps.loadChunk(chk.getX(),chk.getZ()); // this should generate the chunk
    			  
    			  if( ! cps.saveChunks(true,null) ) { // save pending chunks so they can be uncached
	    			  WorldGen.logger.info("Pending unsaved chunks exist");    				  
    			  }

    			  cps.unloadQueuedChunks(); // remove chunks from cache
    			  cps.dropChunk(chk.getX(),chk.getZ()); // get it out of the cache
    		  } else {
//    			  WorldGen.logger.info("-- chunk already exists --");
    		  }

    		  cnt += 1;
    		  if( (cnt&127) == 0 ) { // about 10s if all chunks to be generated on reasonable host
    			  WorldGen.logger.info("Completed "+cnt+" chunks ("+(Math.floor(cnt*1000.0/totchunks)/10.0)+"%) (Loaded:"+cps.getLoadedChunkCount()+")");
    	    	  ics.addChatMessage(new ChatComponentText("Completed "+cnt+" chunks ("+(Math.floor(cnt*1000.0/totchunks)/10.0)+"%)"));
    	    	  if( ! world.getChunkProvider().saveChunks(true,null) ) {
        			  WorldGen.logger.warn("Unable to save all pending chunks");    	    		  
    	    	  }
    			  sh.flush(); // flush saves    			  
    			  cps.unloadQueuedChunks(); // remove chunks from cache
    			  world.getWorldChunkManager().cleanupCache();   // clean up chunk cache
    		  }
    		  world.tick();  // might be too frequent (if no gen required)
    	  }
    	  ics.addChatMessage(new ChatComponentText("Completed "+cnt+" chunks"));    			  
    	  
    	  ics.addChatMessage(new ChatComponentText("Generation Complete"));
	  }
	  
	  public GenCommand()
	  {
	    this.aliases = new ArrayList();
	    this.aliases.add("worldgen");
	    this.aliases.add("wg");
	    this.aliases.add("gen");
	  }

	  @Override
//	  public String getCommandName()
	  public String getName()
	  {
	    return "worldgen";
	  }

	  @Override
	  public String getCommandUsage(ICommandSender icommandsender)
	  {
	    return "worldgen <set [<x1> <z1>] <<x2> <z2>|<r>>|go>";
	  }

	  @Override
//	  public List getCommandAliases()
	  public List getAliases()
	  {
	    return this.aliases;
	  }

	  @Override
//	  public void processCommand(ICommandSender icommandsender, String[] astring)
	  public void execute(ICommandSender icommandsender, String[] astring)
	  {
		  int totchunks = 0;

          if(icommandsender instanceof EntityPlayer){
                  EntityPlayer player = (EntityPlayer)icommandsender;
                  if( ! player.capabilities.isCreativeMode ) {
                	  player.addChatMessage(new ChatComponentText("You must be in Creative mode"));
                	  return;
                  }
          }
		  
	      if(astring.length < 1 ) {
	    	  icommandsender.addChatMessage(new ChatComponentText("Please specify 'set' or 'go'"));
	    	  return;
	      }
    	  WorldGen.logger.info("Processing command ["+astring[0]+"]");
    	  
    	  if(astring[0].startsWith("set")) {
      		  // parse out the numerical parameters
    		  // default second set to HERE if a player, else an error
    		  if( astring.length < 2) {
    	    	  icommandsender.addChatMessage(new ChatComponentText("Please specify 'set [<x> <z>] <x2> <z2>' or 'set [<x> <z>] <r>'"));
    	    	  icommandsender.addChatMessage(new ChatComponentText("Specify center and radius for a circle or two points for a square"));
    	          if(icommandsender instanceof EntityPlayer){
    	        	  icommandsender.addChatMessage(new ChatComponentText("Primary point defaults to current location."));
    	          } else {
    	        	  icommandsender.addChatMessage(new ChatComponentText("Primary point defaults to spawn point"));    	        	  
    	          }
    			  return;
    		  }
    		  if( astring.length < 4 ) {
    	          if(icommandsender instanceof EntityPlayer){
    	        	  from = new BlockPos( (int)((EntityPlayer) icommandsender).posX, 0, (int)((EntityPlayer) icommandsender).posZ );
    	          } else {
    	        	  from = icommandsender.getEntityWorld().getSpawnPoint();
    	          }
    		  } else {
    			  from = new BlockPos( Integer.parseInt(astring[1]),0.0,Integer.parseInt(astring[2]) );
    		  }
    		  if( astring.length == 4 || astring.length == 2 ) {
    			  // radius
    			  centre = new BlockPos(from);
    			  radius = Integer.parseInt(astring[astring.length - 1]);
    			  from = new BlockPos( centre.getX() - radius, 0.0, centre.getZ() - radius );
    			  to = new BlockPos( centre.getX() + radius, 0.0, centre.getZ() + radius );
    		  } else {
    			  // square
    			  radius = 0;
    			  to = new BlockPos( Integer.parseInt(astring[astring.length-2]),0.0,Integer.parseInt(astring[astring.length-1]) );
    		  }
    		  
              if(radius>0) {
            	  totchunks = (int) Math.floor(Math.PI * Math.pow(Math.floor(radius/16), 2.0)+1);
              } else {
            	  totchunks = (int) ((Math.abs(Math.floor(from.getX()/16)-Math.floor(to.getX()/16))+1) * (Math.abs(Math.floor(from.getZ()/16)-Math.floor(to.getZ()/16))+1)); 
              }
              if( radius > 0 ) {
            	  icommandsender.addChatMessage(new ChatComponentText("Selected area is a circle radius "+radius+" blocks centered on "+centre.getX()+","+centre.getZ()));
            	  icommandsender.addChatMessage(new ChatComponentText("Within a rectangle from "+from.getX()+","+from.getZ()+" to "+to.getX()+","+to.getZ()));            	  
              } else {
            	  icommandsender.addChatMessage(new ChatComponentText("Selected area is a rectangle from "+from.getX()+","+from.getZ()+" to "+to.getX()+","+to.getZ()));            	  
              }
			  icommandsender.addChatMessage(new ChatComponentText("Selected area contains approximately "+totchunks+" chunks"));
	          int t = (int)Math.floor(totchunks / Constants.CHUNKRATE);
	    	  icommandsender.addChatMessage(new ChatComponentText("Estimated time: "+t+" minutes"));
			  icommandsender.addChatMessage(new ChatComponentText("Use '/worldgen go' to start generation"));
    		  return;
    	  }
    	  
    	  if(astring[0].startsWith("go")) {
    		  if( this.from == null || this.to == null ) {
    			  icommandsender.addChatMessage(new ChatComponentText("You have not yet set the boundaries of the generation area using '/worldgen set'."));
    			  return;
    		  }
    		  generateChunks(icommandsender);
    		  return;
    	  }

    	  icommandsender.addChatMessage(new ChatComponentText("Invalid subcommand : " + astring[0]));
	      return;
	  }

	  @Override
//	  public boolean canCommandSenderUseCommand(ICommandSender icommandsender)
	  public boolean canCommandSenderUse(ICommandSender icommandsender)
	  {
		  // is the player in create mode or holding the wand?
		  EntityPlayer player;
          
          if(icommandsender instanceof EntityPlayer){
                  player = (EntityPlayer)icommandsender;
                  if( player.capabilities.isCreativeMode ) {
                	  return true;
                  }
            	  player.addChatMessage(new ChatComponentText("You must be in Creative mode"));
        		  return false;
          }
          // console command OK
          return true;
      }

	  @Override
//	  public List addTabCompletionOptions(ICommandSender icommandsender, String[] astring)
	  public List addTabCompletionOptions(ICommandSender icommandsender, String[] astring, BlockPos bp)
	  {
		  List l = null;
		  if( astring.length == 0 ) {
			  l = new ArrayList();
			  l.add("go");
			  l.add("set");
			  return l;
		  }
		  return null;
	  }

	  @Override
	  public boolean isUsernameIndex(String[] astring, int i)
	  {
		  // none of the parameters are usernames
   	      return false;
	  }

	  @Override
	  public int compareTo(Object o)
	  {
	    return 0;
	  }
}
